#load required library
library(caret)

#read table (first column contains predicted classes as numbers, second column contains observed classes)
tab <- read.table("D:/Area2/MGET/V2/rf2000_2_export_for_AccAss.txt", header = TRUE, sep = ",")

pred <- unlist(tab[1], use.names = FALSE)
obs <- unlist(tab[2], use.names = FALSE)

#show confusion matrix
table(pred,obs)

#print confusion matrix with accuracy statistics
#When dealing with presence-absence data choose positive (i.e. presence), for example "1" or "Y"
#confusionMatrix(data, reference, positive = "1")
confusionMatrix(pred,obs, positive = "1") 

