%% Initialization
load('C:\Users\Izawa\Desktop\UH Manoa\UH Research\EP Tset Model\Cost Analysis Model\Data\5ZoneSmallOffice_SA750.mat')
[date, cost] = importLambda();   % Import lambda for price data
tbegin = '22-Jun-2013 00:00:00';    % Referenced and manipulated in plotHVAC and plotTemperature.
tend = '22-Jun-2013 23:55:00';      % Change the date only (not time).
div = 12;    % Divisons per hour. For five minute intervals, 12 samples per hour.
FRAMES(length(vTset)) = struct('cdata',[],'colormap',[]);
doy = 1;
global hideFigures
hideFigures = 0;

%% Main
vTamb = dayLog.Day1(1:12:288,4); % All day temperatures are the same
mode = 1;
NSEWZoneFrames = getframe;  CoreZoneFrames = getframe;
AvgReturnFrames = getframe; CoilCoolingFrames = getframe;
close all
for n=1:1:length(vTset)
    thisDay = ['Day',num2str(n)];
    TsetList = dayLog.(thisDay)(:,1);   % For plotting purposes only

    if mode == 1
    figure(1)
    plot([0:1:24],convtemp((vTset(:,n)),'C','F'), '.-b',[0:1:23],convtemp((vTamb(:)),'C','F'), '.-r');
    ylim([60,100]),xlim([0,24])
    grid on, xlabel('Hour Setpoint'); ylabel('Temperature (F)'); title(['vTset: Iteration ', num2str(n)]);
    elseif mode == 2
        Tamb = dayLog.(thisDay)(:,4);
        Tzone = dayLog.(thisDay)(:,5:9);
        PHVAC = dayLog.(thisDay)(:,10);
        TsetList = convtemp(TsetList,'C','F');  Tamb = convtemp(Tamb,'C','F'); 
        Tzone = convtemp(Tzone,'C','F');
        CoolingPumpAvailSched = dayLog.(thisDay)(:,3);
        plotTemperature(Tamb,TsetList,Tzonimple,tbegin,tend,hideFigures,CoolingPumpAvailSched);   fprintf('...\n')
        titlestr = ['Plot for Tset = ', num2str(TsetList(1)),'F'];
        title(titlestr)
    elseif mode == 3 
        thisDay = ['Day',num2str(n)];
        TsetList = dayLog.(thisDay)(:,1);   % For plotting purposes only
        TsetList = convtemp(TsetList,'C','F');  Tamb = convtemp(Tamb,'C','F'); 
        PHVAC = dayLog.(thisDay)(:,10);
        tstep = [1 1 1 30];
        Pelec = plotHVAC(PHVAC,cost,doy,tstep,div,hideFigures);                              fprintf('...\n')
        subplot(3,1,2)
        titlestr = ['Plot for Tset = ', num2str(TsetList(1)),'F'];
        title(titlestr)
        ylim([0,30e3])
        subplot(3,1,3)
        ylim([0,5])
    elseif mode == 4
        [NSEWZoneFrames, CoreZoneFrames,AvgReturnFrames,CoilCoolingFrames] ...
        = plotRemainingOutputs(dayLog,thisDay,tbegin,tend,n, ...
        NSEWZoneFrames, CoreZoneFrames,AvgReturnFrames,CoilCoolingFrames,convtemp(TsetList(1),'C','F'));
    end 
    if mode < 4
    drawnow
    set(gcf,'units','normalized','outerposition',[0 0 1 1])
    FRAMES(n) = getframe(gcf);
    close all
    end 
end

