function [Tset]  = convForMODE2(cooldownCount,multiDayTset)
    remainingOccupiedHrs = 8;   % noon to 8pm
    remainingUnoccupiedHrs = 4; % 8pm to midnight
    nextDay = 14*cooldownCount;
    TsetOccupiedHrs = kron(multiDayTset(13+nextDay),ones(1,remainingOccupiedHrs-1));
    TsetUnoccupiedHrs = kron(multiDayTset(14+nextDay),ones(1,remainingUnoccupiedHrs+1));
    Tset = [multiDayTset(1+nextDay:12+nextDay),TsetOccupiedHrs,TsetUnoccupiedHrs];
    Tset = repmat(Tset(1:24),1,5);  % Replicate setpoints for all 5 zones for this day.               
end 