function [searchname] = createTsetHistory(numHistDays,preCondTsetVec,dateObj,c1Str,totalnumdays,DOY,dirName)
% Creates the proper history file, and always wipes it clean for each
% runthrough. defaultTsetHistory should have as many rows as numHistDays.
% The month, day and year correspond to the very first simulated day. Since
% we simulate a pre-conditioning period, this should be numHistDays after
% the start day in the Energyplus file. 
% Note dateObject should come from the datenum() function. 
    %dirName = '/home/atizawa/lus/Window_Shifting_Logs';
    if exist(dirName,'dir') ~= 7
        mkdir(dirName); 
    end
    
    cd(dirName);
    dateFormat = 'dd-mmm-yyyy';
    logFilename = ['TsetHistory_',datestr(dateObj,dateFormat),'_to_',datestr(addtodate(dateObj,totalnumdays,'day'),dateFormat),'_C1-',c1Str,'.csv'];
    defaultTset = reshape(preCondTsetVec,length(preCondTsetVec)/numHistDays,numHistDays)';
    if size(defaultTset,1) ~= numHistDays
        errorStr = ['Bad defaultTset dimensions. numHistDays was ',num2str(numHistDays), ...
                   ', but defaultTset had only ' num2str(size(defaultTset,1)),' rows. Quitting.'];
        error(errorStr);
    end 

    % Otherwise we should be good to go. Reshape Tset from vector to matrix
    % representing the subsequent days.

    dimTset = size(defaultTset,2); 
    TsetStr = genvarname(repmat({'Tset'},1,dimTset+1)); TsetStr = TsetStr(2:end);
    
    fid = fopen(logFilename,'w');
    header = {dateFormat,TsetStr{:},'Pelec','Pdisc','Netcost','WattHours','DOY','Write_Hr','Write_Min'}; 
    fprintf(fid,'%s,',header{1:end-1}); fprintf(fid,'%s',header{end}); fprintf(fid,'\n');

    for i = 1:numHistDays
        dateStr = [datestr(addtodate(dateObj,-(numHistDays-i+1),'day'),dateFormat),','];
        TsetStr = sprintf('%.3f,',defaultTset(i,:));
        emptyStr = ['0,0,0,0,',num2str(DOY),',',datestr(datetime('now'),'HH'),',',datestr(datetime('now'),'MM'),','];

        writeStr = [dateStr,TsetStr,emptyStr];
        fprintf(fid,'%s\n',writeStr(1:end-1));
    end 

    fclose(fid);
    cd('/home/atizawa/apps/Cost-Analysis-Model')
    searchname = [dirName,'/',logFilename];
    fprintf(['Started history log: ',searchname,'\n'])
end