%genEPTset: generates random temperature setpoint values and can also
%convert to the EnergyPlus text format if needed.

function [strTset,Tset] = genEPTset()


    fprintf('Generating new Tsetpoint vector.\n')
    count = 1;
    Tset = zeros(1,24);
    strTset = cell(24,1);
    for i = 0:1:23
        hour = floor(i);
        min = mod(i,1)*60;
        random = round( (25+rand()*4*(-1)^round(rand)) *10)/10;
        %if random > vTempAmb(i+2)
        %    random = vTempAmb(i+1);
        %end 
        %fprintf(['Until: ', '%02d',':','%02d', ',', num2str(random),',\n'],hour,min);
        strTset{count} = ['Until: ', sprintf('%02d',hour), ':',sprintf('%02d',min), ',', num2str(random),','];
        Tset(count) = random;
        count = count+1;
    end
    
    Tset = transpose(Tset);
end 