function [Tset_Heu] = getHeuristic(TsetDef,DOY,numMultiDays)
    % Retrieves some Tset vectors to seed PSO with based on the LMP for
    % electricity. There are two heuristics:
    % 1) Assume the default schedule except where prices are extremely low.
    %    (This is based on pre-determined knowledge). These hours are
    %    pre-chilled to 19C. 
    % 2) Slightly more tolerant pre-chill heuristic with a higher
    % threshold, where we cool to 22C. 

    % ONLY USE WITH MODE = 2.
        
    numHeu = 2; 
    
    costVec = importLambda();
    costVec = transpose(costVec(DOY:DOY+numMultiDays-1,:)); % Prices for numMultiDays.


    Tset_Heu = zeros(numHeu,14*numMultiDays);

    %% Pre-chill Heuristic
    minThres = 50; 
    midThres = 150;

    % Average remainder of occupied period and remainder of unoccupied periods. 
    costVec = [costVec(1:12,:);mean(costVec(13:19,:),1);mean(costVec(20:24,:),1)];
     
    minInd = find(costVec < minThres);  % Linearized indices thanks to transpose().
    Tset_Heu(1,:) = repmat(TsetDef,1,numMultiDays);
    Tset_Heu(1,minInd) = 19;

    midInd = find(costVec > minThres & costVec < midThres);
    Tset_Heu(2,:) = Tset_Heu(1,:);
    Tset_Heu(2,midInd) = 22; 

end