function [] = plotTemperature(Tamb,TsetList,Tzone,tbegin,tend,hideFigures,CoolingPumpAvailSched)
    if hideFigures == 1
        return
    end 

    figure(5); 
    n = 5; interval = [1 1 1 n]; hold all
    plotDate(Tamb,tbegin,tend,interval,'-'); ylabel('Degrees F'), xlabel('Time (5 Min Intervals)'), grid on, title('Ambient Temperature')
    for zoneNum = 1:size(Tzone,2)
        plotDate(Tzone(:,zoneNum),tbegin,tend,interval,'.-'); ylabel('Degrees F'), xlabel('Time (5 Min Intervals)'), grid on, title('Ambient Temperature')
    end 
    plotSetPoints(CoolingPumpAvailSched+60*ones(length(CoolingPumpAvailSched),1),tbegin,tend,[1 1 1 5],'k-');
    plotSetPoints(TsetList,tbegin,tend,[1 1 1 30],'k-.'); ylabel('Degrees F'), 

    xlabel('Time (5 min sampling)'), grid on,
    rotateticklabel(gca);
    hline = findobj(gcf, 'type', 'line');
    %set(hline,'LineWidth',2)
    %legend('Ambient','Core','Zone South','Zone East','Zone North','Zone West','Random Set Points')
    legend('Ambient','South','East','North','West','Core','Random Set Points')
    %legend('Ambient','Gnd West Zone','Gnd Center Zone', 'Gnd East Zone', 'Mid West Zone', 'Mid Center Zone', ...
    %       'Mid East Zone', 'Top West Zone', 'Top Center Zone', 'Top East Zone','Random Set Points')
end 

function [tvec,t] = plotSetPoints(arr,strsrt,strend,step,plotstr)     % plotstr is just the modifier for custom plots
    global hideFigures
    
    start = datenum(strsrt);  last = datenum(strend);
    t = linspace(start,last,length(arr));
   
    
    tvec = datelist(start, last, 1:step(1):12, 1:step(2):31,1:step(3):24,0:step(4):60);
    
    if hideFigures == 1                         % Don't waste time plotting.
        return
    end 
    
    if nargin == 5
        stairs(t, arr, plotstr)
    else
        stairs(t, arr)
    end
    
        set(gca, 'xlim', [start last], 'xtick', tvec)
        datetick('keepticks', 'keeplimits'), grid on;
end 




