function [] = writeDayLogStruct2CSV(dayLog,fullPath,dateObj,doyInt)
    listOfNames = fieldnames(dayLog);
    header = {'Tset_Zone1 (C)','Tset_Zone2 (C)','Tset_Zone3 (C)','Tset_Zone4 (C)','Tset_Zone5 (C)', ...
              'ReheatStatus1','ReheatStatus2','ReheatStatus3','ReheatStatus4','ReheatStatus5', 'CoolingCoilON', ...
              'Tamb (C)','Tzone1 (C)','Tzone2 (C)','Tzone3 (C)','Tzone4 (C)','Tzone5 (C)','PHVAC (W)', ...
              'Zone 1 PMV','Zone 2 PMV','Zone 3 PMV','Zone 4 PMV','Zone 5 PMV',...
              'Bottom Cooling Coil Sensible Cooling Rate (W)' ...
              'Middle Cooling Coil Sensible Cooling Rate (W)' ...
              'Top Cooling Coil Sensible Cooling Rate (W)' ...
              'Basement Cooling Coil Sensible Cooling Rate (W)' };
    fullPath = [fullPath,'/','CSV_Data-Planned_',datestr(dateObj),'_DOY',num2str(doyInt) ];
    if exist(fullPath,'dir') ~= 2, mkdir(fullPath); disp(['Made directory: ' fullPath]); end 
    
    for i = 1:length(listOfNames)
        thisName = listOfNames{i};
        logFile = [fullPath,'/',thisName,'.csv'];
        data = dayLog.(thisName);

        fid = fopen(logFile,'w');
        fprintf(fid,'%s,',header{1:end-1}); fprintf(fid,'%s',header{end}); fprintf(fid,'\n'); 
        fclose(fid);
        dlmwrite(logFile,data,'-append','precision','%.4f','delimiter',',')
        disp(['Wrote to:' logFile])
    end 
    disp('Done writing log files.')
end 