function TsetHistory01Aug2012to31Aug2012C11 = openFullLog(filename)
%IMPORTFILE Import numeric data from a text file as a matrix.
%   TSETHISTORY01AUG2012TO31AUG2012C11 = IMPORTFILE(FILENAME) Reads data
%   from text file FILENAME for the default selection.
%
%   TSETHISTORY01AUG2012TO31AUG2012C11 = IMPORTFILE(FILENAME, STARTROW,
%   ENDROW) Reads data from rows STARTROW through ENDROW of text file
%   FILENAME.
%
% Example:
%   TsetHistory01Aug2012to31Aug2012C11 =
%   importfile('TsetHistory_01-Aug-2012_to_31-Aug-2012_C1-1.7e-3.csv', 9,
%   39);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2016/04/19 09:21:26
startRow = 9;
endRow = 39;
%% Initialize variables.
delimiter = ',';
if nargin<=2
    startRow = 9;
    endRow = inf;
end

%% Format string for each line of text:
%   column16: double (%f)
%	column17: double (%f)
%   column18: double (%f)
%	column19: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%f%f%f%f%*s%*s%*s%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(1)-1, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(block)-1, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Create output variable
TsetHistory01Aug2012to31Aug2012C11 = [dataArray{1:end-1}];
