import os
import math
import numpy as np
import time
import string
from datetime import datetime

def dis(x,y):
    return ((x[0]-y[0])**2+(x[1]-y[1])**2+(x[2]-y[2])**2)**0.5

def angle(c1,c2,c3):
	d1=dis(c1,c2)
	d2=dis(c2,c3)
	d3=dis(c1,c3)
	temp=(d1**2 + d2**2 - d3**2)/(2*d1*d2)
	alpha=(math.acos(temp))*180/(math.pi)
	return alpha#alpha=angle-c1-c2-c3


directory='.'

extension = ".pdb"
files = [file for file in sorted(os.listdir(directory)) if file.lower().endswith(extension)]
mainchainAtoms=['H','N','CA','HA','C','O']
atomtype=[]




for f in files:
	
	w=open(f)
	lines=w.readlines()
	w.close()
	for i in range(len(lines)):
		if len(lines[i].split()) >11  and 'ATOM' in lines[i][:5]:#for sidechain hydrogen
			if lines[i].split()[11]=='H' and not lines[i].split()[2] in mainchainAtoms:
				for j in range(len(lines)):#for HB donor
					if len(lines[j].split())>11 and 'ATOM' in lines[j][:5]:
						if lines[i].split()[3]+lines[i].split()[4]+lines[i].split()[5]==lines[j].split()[3]+lines[j].split()[4]+lines[j].split()[5] and lines[j].split()[11] in ['N','O','S'] and not lines[j].split()[2] in mainchainAtoms:
							for k in range(len(lines)):#for HB acceptor
								if k!=j and len(lines[k].split())>11 and 'ATOM' in lines[k][:5]:
									if lines[k].split()[11] in ['N','O','S'] and not lines[k].split()[2] in mainchainAtoms and lines[i].split()[3]+lines[i].split()[4]+lines[i].split()[5]!=lines[k].split()[3]+lines[k].split()[4]+lines[k].split()[5]:
#only sidechain HB are calculated.
										li,lj,lk=lines[i],lines[j],lines[k]
										res_chain_resNum=[]
										IDi=li.split()[3] + '_' + li.split()[4] + '_' + li.split()[5]
										IDj=lj.split()[3] + '_' + lj.split()[4] + '_' + lj.split()[5]
										IDk=lk.split()[3] + '_' + lk.split()[4] + '_' + lk.split()[5]
										res_chain_resNum.append(IDi)
										res_chain_resNum.append(IDj)
										res_chain_resNum.append(IDk)
										if len(list(set(res_chain_resNum)))==2:#make sure HB is inter-residue
											DonorIdx=j
											AcceptorIdx=k
											x1=float(li[30:38])
											y1=float(li[38:46])
											z1=float(li[46:54])
											coorH=[x1,y1,z1]
											x1=float(lines[DonorIdx][30:38])
											y1=float(lines[DonorIdx][38:46])
											z1=float(lines[DonorIdx][46:54])	
											coorDonor=[x1,y1,z1]
											x1=float(lines[AcceptorIdx][30:38])	
											y1=float(lines[AcceptorIdx][38:46])
											z1=float(lines[AcceptorIdx][46:54])
											coorlinesAcceptor=[x1,y1,z1]
											if dis(coorlinesAcceptor,coorDonor)<=3 and dis(coorDonor,coorH)<=1.1:#make sure that the sidechain HB group(HS,HO,or HN) is bonded:
												if angle(coorlinesAcceptor,coorDonor,coorH)<=30:
													print '%s\t%.2f\t%.2f\t%s\t%s' %(f,dis(coorlinesAcceptor,coorDonor),angle(coorlinesAcceptor,coorDonor,coorH),lines[i][:-1].split()[3]+'_' +lines[i][:-1].split()[4]+'_' +lines[i][:-1].split()[5],lines[AcceptorIdx][:-1].split()[3]+'_' +lines[AcceptorIdx][:-1].split()[4]+'_' +lines[AcceptorIdx][:-1].split()[5])
													print lines[i][:-1],'\n',lines[AcceptorIdx][:-1],'\n',lines[DonorIdx][:-1]


print 'Above is a list of HBs found from this PDB entry, all sidechain HBs, no backbone atom involved'
