import os
import math
import numpy as np
import time
import string
from datetime import datetime


def dis(x,y):
    return ((x[0]-y[0])**2+(x[1]-y[1])**2+(x[2]-y[2])**2)**0.5

def angle(c1,c2,c3):
	d1=dis(c1,c2)
	d2=dis(c2,c3)
	d3=dis(c1,c3)
	temp=(d1**2 + d2**2 - d3**2)/(2*d1*d2)
	alpha=(math.acos(temp))*180/(math.pi)
	return alpha#alpha=angle-c1-c2-c3


directory='.'

extension = ".pdb"
files = [file for file in sorted(os.listdir(directory)) if file.lower().endswith(extension)]
#mainchainAtoms=['H','N','CA','HA','C','O']
mainchainAtoms=[]
atomtype=[]


w=open('HB_alles.output').readlines()

idxlist=[]
for line in w:
	if '.pdb' in line:
		idxlist.append(w.index(line))
		
#print idxlist


t=0
for idx in idxlist:
	line=w[idx]
	pdbID=line[:-1].split()[0].replace('_model_','\_').upper()
	acceptor=w[idx+2]
	donor=w[idx+3]
	hydrogen=w[idx+1]
	acceptorAtom=acceptor.split()[2]
	donorAtom=donor.split()[2]
	hydrogenAtom=hydrogen.split()[2]
	acceptorResidue=acceptor.split()[4]+'\_' + acceptor.split()[3]+'\_' + acceptor.split()[5]
	donorResidue=donor.split()[4]+'\_' + donor.split()[3]+'\_' + donor.split()[5]
	hydrogenResidue=hydrogen.split()[4]+'\_' + hydrogen.split()[3]+'\_' + hydrogen.split()[5]
	x=acceptor.split()[6]
	y=acceptor.split()[7]
	z=acceptor.split()[8]
	acceptorCoor=[float(x),float(y),float(z)]
	x=donor.split()[6]
	y=donor.split()[7]
	z=donor.split()[8]
	donorCoor=[float(x),float(y),float(z)]
	x=hydrogen.split()[6]
	y=hydrogen.split()[7]
	z=hydrogen.split()[8]
	hydrogenCoor=[float(x),float(y),float(z)]
	if t % 2 ==0:
		print pdbID + '\t&\t' + acceptorAtom + ', ' + acceptorResidue +   	'\t&\t' + donorAtom + ', ' + donorResidue + '\t&\t' + hydrogenAtom + ', ' + hydrogenResidue + '\t&\t' + '%.2f'%dis(acceptorCoor,donorCoor) + '\t&\t' +'%.2f'%dis(acceptorCoor,hydrogenCoor) + '\t&\t' + '%.2f'%(angle(acceptorCoor,donorCoor,hydrogenCoor)) + '\\\\\\hline'
	else:
		print '\\rowcolor{gray}' + pdbID + '\t&\t' + acceptorAtom + ', ' + acceptorResidue +   	'\t&\t' + donorAtom + ', ' + donorResidue + '\t&\t' + hydrogenAtom + ', ' + hydrogenResidue + '\t&\t' + '%.2f'%dis(acceptorCoor,donorCoor) + '\t&\t' +'%.2f'%dis(acceptorCoor,hydrogenCoor) + '\t&\t' + '%.2f'%(angle(acceptorCoor,donorCoor,hydrogenCoor)) + '\\\\\\hline'
	t+=1
	
	
	
	
	
	
	
	
print 'kiwi'	
	
	
	
	

w=open('HB_sidechain.output').readlines()

idxlist=[]
for line in w:
	if '.pdb' in line:
		idxlist.append(w.index(line))
		
#print idxlist

t=0
for idx in idxlist:
	line=w[idx]
	pdbID=line[:-1].split()[0].replace('_model_','\_').upper()
	acceptor=w[idx+2]
	donor=w[idx+3]
	hydrogen=w[idx+1]
	acceptorAtom=acceptor.split()[2]
	donorAtom=donor.split()[2]
	hydrogenAtom=hydrogen.split()[2]
	acceptorResidue=acceptor.split()[4]+'\_' + acceptor.split()[3]+'\_' + acceptor.split()[5]
	donorResidue=donor.split()[4]+'\_' + donor.split()[3]+'\_' + donor.split()[5]
	hydrogenResidue=hydrogen.split()[4]+'\_' + hydrogen.split()[3]+'\_' + hydrogen.split()[5]
	x=acceptor.split()[6]
	y=acceptor.split()[7]
	z=acceptor.split()[8]
	acceptorCoor=[float(x),float(y),float(z)]
	x=donor.split()[6]
	y=donor.split()[7]
	z=donor.split()[8]
	donorCoor=[float(x),float(y),float(z)]
	x=hydrogen.split()[6]
	y=hydrogen.split()[7]
	z=hydrogen.split()[8]
	hydrogenCoor=[float(x),float(y),float(z)]
	if t % 2 ==0:
		print pdbID + '\t&\t' + acceptorAtom + ', ' + acceptorResidue +   	'\t&\t' + donorAtom + ', ' + donorResidue + '\t&\t' + hydrogenAtom + ', ' + hydrogenResidue + '\t&\t' + '%.2f'%dis(acceptorCoor,donorCoor) + '\t&\t' +'%.2f'%dis(acceptorCoor,hydrogenCoor) + '\t&\t' + '%.2f'%(angle(acceptorCoor,donorCoor,hydrogenCoor)) + '\\\\\\hline'
	else:
		print '\\rowcolor{gray}' + pdbID + '\t&\t' + acceptorAtom + ', ' + acceptorResidue +   	'\t&\t' + donorAtom + ', ' + donorResidue + '\t&\t' + hydrogenAtom + ', ' + hydrogenResidue + '\t&\t' + '%.2f'%dis(acceptorCoor,donorCoor) + '\t&\t' +'%.2f'%dis(acceptorCoor,hydrogenCoor) + '\t&\t' + '%.2f'%(angle(acceptorCoor,donorCoor,hydrogenCoor)) + '\\\\\\hline'
	t+=1
	
