# -*- coding: utf-8 -*-
"""
@author: Martin Paul
"""



import os
import glob
import numpy as np
from matplotlib import pyplot as plt
from astropy.io import fits
from scipy import signal




###############################################################################




###############################################################################
# 1 Working directory:                                                        #
#     a )sets the directory and imports txt files                             #
###############################################################################


sourceDir = "C:\\Users\\martin\\Desktop\\cocaine\\data\\"


if not os.path.isdir(sourceDir):
	raise NotADirectoryError(sourceDir)



###############################################################################
# 1b) .txt import                                                             #
###############################################################################


hotpixels = np.loadtxt(sourceDir + "hotpixels_1920_1200.txt")
hotpixels = hotpixels.astype("int") 

roiRegion = np.genfromtxt(sourceDir + "roi_region_x_y.txt")
roiRegion = roiRegion.astype("int")

x_start = roiRegion[0,0];
x_end = roiRegion[1,0];

y_start = roiRegion[0,1];
y_end = roiRegion[1,1];


###############################################################################
# 1c) .fits import and file search                                            #
###############################################################################

sf = glob.glob(sourceDir + "/*.fits")

print("In total " + str(len(sf)) + " .csv files were found and saved in the sf dictionary!")
if not os.path.isdir(sourceDir):
	raise NotADirectoryError(sourceDir)



dataFrameDictCold = {} # rawdata with removed

for i in range(len(sf)):
    interrim = fits.open(sf[i])[0].data
    for k in range(len(hotpixels)):
        #print("test")
        interrim[hotpixels[k][1],hotpixels[k][0]] = 0

    dataFrameDictCold[i] = interrim


# Our function to fit is going to be a sum of two-dimensional Gaussians
def gaussian(x, y, x0, y0, xalpha, yalpha, A, offset):
    return A * np.exp( -((x-x0)/xalpha)**2 -((y-y0)/yalpha)**2)+offset



def _gaussian(M, *args):
    x, y = M
    arr = np.zeros(x.shape)
    for i in range(len(args)//6):
       arr += gaussian(x, y, *args[i*6:i*6+6])
    return arr


guess_prms = [(1025 ,700 ,4 ,4 ,1000 , 0)]
p0 = guess_prms

x, y = np.arange(x_start,x_end,1) , np.arange(y_start,y_end,1)
X, Y = np.meshgrid(x, y)


###############################################################################
# 2    Data Evaluation with fixed roi                                         #
###############################################################################

#%%


guess_prms = [(1010 ,685 ,4 ,4 ,1000 , 0)]

evalType = "y"


if evalType == "y":

    results_array = []
    xdata = np.vstack((X.ravel(), Y.ravel()))


    for i in range(len(dataFrameDictCold)):
        
        roi_hw = 4 #3
        lb = 8
        hb = 3

        data_post = dataFrameDictCold[i][x_start:x_end,y_start:y_end]
        
        x_center = 1#int(round(popt[0]))-2
        y_center = 1#int(round(popt[1]))+3
       

        interrim = np.mean(np.sort(data_post.flatten())[-lb:-hb])
        row =interrim
        fit = None
        
        results_array = np.append(results_array,[i,row,x_center,y_center])
        print("file number :" + str(i) + " x = : " + str(x_center) + " y = " + str(y_center) + " median : " + str(interrim))

    results_array = results_array.reshape(len(dataFrameDictCold),4)
else:
    print("error")

plt.plot(np.sort(dataFrameDictCold[1][x_center-roi_hw:x_center+roi_hw,y_center-roi_hw:y_center+roi_hw].flatten()))
# show data 
 
def plot_fun_bulk(x1,x2):
    
    fig = plt.figure(figsize=(8,10))
    fig.tight_layout()
    fig.subplots_adjust(hspace=0.25)
    #x1 = 240
    #x2 = 260
    
    ax1 = fig.add_subplot(2,1,1)
    ax1.scatter(results_array[::,0][x1:x2],results_array[::,2][x1:x2],s = 2, color = "#00aef9", label = "x-pixel")
    ax1.set_title("central pixel")
    ax1.set_ylim((np.min(results_array[::,2][x1:x2])-1.5,np.max(results_array[::,2][x1:x2])+1.5))
    ax1.set_xlabel("time [min]")
    ax1.set_ylabel("pixel number")
    ax1.legend(loc=1)  
    
    ax2 = ax1.twinx()
    ax2.scatter(results_array[::,0][x1:x2],results_array[::,3][x1:x2],s = 2, color = "#8bb40f", label = "y-pixel")
    ax2.set_ylim((np.min(results_array[::,3][x1:x2])-1,np.max(results_array[::,3][x1:x2])+1))
    ax2.set_xlabel("time [min]")
    ax2.set_ylabel("pixel number")
    ax2.legend(loc=0)
     
    
    ax3 = fig.add_subplot(2,1,2)
    ax3.scatter(results_array[::,0][x1:x2],results_array[::,1][x1:x2],s = 2, color = "#d2001e")
    ax3.scatter(results_array[::,0][x1:x2],signal.medfilt(results_array[::,1][x1:x2],3),s = 2, color = "#00aef9")
    ax3.set_title("signal intensity in the roi")
    ax3.set_xlabel("time [min]")
    ax3.set_ylabel("intensity")
   
    


###############################################################################
# 3 Data export                                                               #
###############################################################################

fmt = "\t".join(["%s"] + ["%10.3e"] * (results_array.shape[1]-1))
np.savetxt("file_name.txt", results_array, fmt=fmt, header=
"source directory of the raw data: " +"\n"+
"\n"+
"     " +     sourceDir + "\n" +
"\n"+
"\n"+
"fit guess: "  "\n" +
"\n"+
"     x0_guess = " + str(guess_prms[0][0]) + "\n"+
"     y0_guess = " + str(guess_prms[0][1]) + "\n"+
"     x_alpha guess = " + str(guess_prms[0][2]) + "\n"+
"     y_alpha guess = " + str(guess_prms[0][3]) + "\n"+
"     A guess = " + str(guess_prms[0][4]) + "\n"+
"     offset_guess = " + str(guess_prms[0][5]) + "\n"+
"\n"+
"\n"+
"Evaluation specific data: "  "\n" +
"\n"+
"     halfwidth of the ROI square in pixels    = " + str(roi_hw) + "\n"+
"     ROI square in pixels (number)   = " + str((roi_hw*2)*(roi_hw*2)) + "\n"+
"     roi_region (x) :" + str(roiRegion[0,0]) +  "-" + str(roiRegion[1,0]) + "\n"+
"     roi_region (Y) :" + str(roiRegion[0,1]) +  "-" + str(roiRegion[1,1]) + "\n"+
"     lower border pixel :" + str(lb) +  "\n"+
"     higher border pixel :" + str(hb) +  "\n"+
"\n"+
"Columns: "  "\n" +
"     1: frame number " + "\n" +
"     2: median intensity of the ROI" "\n" +
"     3: x0 center of the roi " "\n" +
"     4: y0_center of the roi" "\n" 
           , comments='')








