clc 
close all
% 调用自适应遗传算法aga
% 输入：
%   求解问题的参数个数         57 57根矩形风管的宽和高 WandH (57×2cell)
%   目标函数                  [fitness,data] = ahydcal(pipecode,info);
%                                              ahydcal中的a代表加入了自适应惩罚函数
%   种群规模                  50
%   交叉概率和变异概率        在遗传迭代中自适应变化，无需输入
%   最大遗传代数              100
%   最小化目标值              (不平衡风管数 < 目标值) 可缺省，计算到最大遗传代数
% 输出：
%   best_unbal              最佳个体的不平衡管段数
%   best_uneco              最佳个体的不经济管段数最小值
%   best_fitness            最佳适应度
%   best_Psummax            最佳个体的最不利阻力
%   elite                   每一代种群中的最优管径组合
%   generation              如设置了最小化目标值，达到目标将提前结束迭代，输出当前遗传代数
%   last_population         当前遗传代数下的最优管径组合编码，具体管径及计算结果见data
%   data                    最优管径组合下的水力计算表
[best_unbal, best_uneco, best_fitness, best_Psummax,elite, generation, last_population, data, z, pc, pm] ...
    = aga(57, 'ahydcal', 50, 100, 5);

% 不平衡管段数，不经济管段数，最不利阻力，可行解比例，交叉概率，变异概率的变化
plotdata = [best_unbal(1:length(z)), best_uneco(1:length(z)), best_Psummax(1:length(z)), z', pc', pm'];
ylabels = {'Minimum unbalanced pipes', 'Minimum uneconomical pipes', 'Most unfavorable resistance', ...
           'Proportion of feasible solutions', 'Crossover probability', 'Mutation probability'};
for i = 1:size(plotdata, 2)
    figure
    plot(1:length(z), plotdata(:, i), 'linewidth', 2)
    xlabel('Number of iterations','fontsize',12);
    ylabel(ylabels{i},'fontsize',12);
    set(gca,'fontsize',12,'ticklength',get(gca,'ticklength')*2);
    ylim([0, max(plotdata(:, i)) + 2]);
    if i == 3
        ylim([0, 300]);
    end
    if i > size(plotdata, 2) - 3
        ylim([0, 1]);
        if i > size(plotdata, 2) - 2
            ylim('auto');
        end
    end
end

% 最优解的变化 风管1到风管end路径中各风管的管径编码
figure
plot(1 : generation, elite(1 : generation, data{end, 8}))
xlabel('Number of iterations','fontsize',12);
ylabel('Best Solution','fontsize',12);
set(gca,'fontsize',12,'ticklength',get(gca,'ticklength')*2);
ylim([0, 35]);
