function pipecode = encodepipe(WandH)
    % 根据给定的多组管径组合编码为整数pipecode数组
    combinations = [
        120, 120;
        160, 120;
        200, 120;
        160, 160;
        250, 120;
        200, 160;
        320, 120;
        200, 200;
        250, 160;
        250, 200;
        320, 160;
        250, 250;
        320, 200;
        400, 160;
        320, 250;
        400, 200;
        400, 250;
        500, 200;
        320, 320;
        500, 250;
        400, 320;
        630, 250;
        400, 400;
        500, 320;
        500, 400;
        630, 320;
        500, 500;
        630, 400;
        800, 320;
        800, 400;
        800, 500;
        1000, 400
    ];

    num_combinations = size(combinations, 1);
    num_inputs = size(WandH, 1);
    pipecode = zeros(1, num_inputs);

    for i = 1:num_inputs
        for j = 1:num_combinations
            if isequal(WandH(i, :), combinations(j, :))
                pipecode(i) = j;
                break;
            end
        end
    end
end
