clc 
close all
% 调用遗传算法ga
% 输入：
%   求解问题的参数个数         57 57根矩形风管的宽和高 WandH (57×2cell)
%   目标函数                  [fitness,data] = hydcal(pipecode,info);
%   种群规模                  50
%   每一代中保持不变的个体数   25 (交叉概率0.5)
%   变异概率                  0.1 (1/10的个体发生变异)
%   最大遗传代数              200
%   最小化目标值              (不平衡风管数 < 目标值) 可缺省，计算到最大遗传代数
% 输出：
%   best_unbal              不平衡管段数最小值
%   best_uneco              不经济管段数最小值
%   elite                   每一代种群中的最优管径组合
%   generation              如设置了最小化目标值，达到目标将提前结束迭代，输出当前遗传代数
%   last_population         当前遗传代数下的最优管径组合编码，具体管径及计算结果见data
%   data                    最优管径组合下的水力计算表
[best_unbal, best_uneco, best_Psummax, elite, generation, last_population, data] = ga(57, 'hydcal', 50, 25, 0.1, 100, 5);

% 不平衡管段数，不经济管段数，最不利阻力的变化
plotdata = [best_unbal(1:generation), best_uneco(1:generation), best_Psummax(1:generation)];
ylabels = {'Minimum unbalanced pipes', 'Minimum uneconomical pipes', 'Most unfavorable resistance'};
for i = 1:size(plotdata, 2)
    figure
    plot(1:generation, plotdata(:, i), 'linewidth', 2)
    xlabel('Number of iterations','fontsize',12);
    ylabel(ylabels{i},'fontsize',12);
    set(gca,'fontsize',12,'ticklength',get(gca,'ticklength')*2);
    ylim([0, max(plotdata(:, i)) + 2]);
    if i == size(plotdata, 2) - 3
        ylim('auto');
    end
end

% 最优解的变化 风管1到风管end路径中各风管的管径编码
figure
plot(1 : generation, elite(1 : generation, data{end, 8}))
xlabel('Number of iterations','fontsize',12);
ylabel('Best Solution','fontsize',12);
set(gca,'fontsize',12,'ticklength',get(gca,'ticklength')*2);
ylim([0, 35]);
