% 读取水力计算管路信息info
function info = readpipe
    [info, ~, raw] = xlsread('hydcal.xlsx');
    info = num2cell(info);
    % 读取通风系统的连接方式connections，即每根风管的下游风管的编号
    col2Data = raw(2:end, 2);
    connections = cell(size(col2Data));
    for i = 1:numel(col2Data)
        % 如果是空值，将cell中对应位置设置为[]
        if isnan(col2Data{i})
            connections{i} = [];
        % 如果是字符型数据，使用str2num将逗号分隔的数字转换为数组
        elseif ischar(col2Data{i})
            nums = str2num(col2Data{i});
            connections{i} = nums;
        % 如果是数字，直接存储在cell中
        else
            connections{i} = col2Data{i};
        end
    end
    info(:, 2) = connections;
end

