%% Script that generates Figure 1 - Audiogram
clear,clc,close all

%% Variables initialization
T = readtable('../Metadata.xlsx');
MD.Audiometry = [T.LA250 T.LA500 T.LA1000 T.LA2000 T.LA3000 T.LA4000 ...
    T.LA6000 T.LA8000 T.RA250 T.RA500 T.RA1000 T.RA2000 T.RA3000 T.RA4000 ...
    T.RA6000 T.RA8000];
f = [250,500,1000,2000,3000,4000,6000,8000];
FS = 10;    LW = 1;

%% Figure generation
figure('PaperSize',[20,25])
for Subj=1:20
    subplot(5,4,Subj),hold on,box on,grid on,
    plot(f,MD.Audiometry(Subj,1:8),'-ob','LineWidth',LW,'MarkerSize',4);
    plot(f,MD.Audiometry(Subj,9:16),'-xr','LineWidth',LW,'MarkerSize',4);
    % plot([500,10e3],[30 30],'--k','LineWidth',LW)
    set(gca,'YDir','reverse','xscale','log')
    set(gca,'xtick',f,'xticklabel',{'','0.5','1','2','','4','','8',},'FontSize',FS-1,'xtickLabelRotation',0)
    set(gca,'ytick',0:20:100,'FontSize',FS-1)
    axis([200 10000 0 100])
    if (Subj>16), xlabel('Frequency (kHz)','FontSize',FS); end
    if(Subj==1 || Subj==5 || Subj==9 || Subj==13 || Subj==17)
        ylabel('Hearing threshold (dB)','FontSize',FS)
    end
    if Subj<10, title(['P0' num2str(Subj)],'FontSize',FS)
    else,       title(['P'  num2str(Subj)],'FontSize',FS); end
    if Subj==4, legend('Left ear','Right ear'); end
end
orient tall
print('-dpng','-r600','FigureA1')
close all